Rem *************************************AD7715**************************
Rem                         16bit Sigma-Delta ADC with SPI
Rem                            Code By Hamidreza Rezaei
Rem                              http:\\Hrezaei.ir
Rem *********************************************************************

$regfile = "m32def.dat"
$crystal = 8000000
$baud = 19200
$hwstack = 128
$swstack = 128
$framesize = 128

Config Lcd = 16 * 2
Config Lcdpin = Pin , Db4 = Porta.2 , Db5 = Porta.3 , Db6 = Porta.4 , _
Db7 = Porta.5 , E = Porta.1 , Rs = Porta.0
Cursor Off
Cls
Lcd "AD7715 Simple Board"
Print "AD7715 Simple Board"
Wait 5
Config Pinb.3 = Input
Config Portb.2 = Output
Config Portb.1 = Output

Const Res = .3814
Const Res_div = .0001

Dim Calc As Integer
'-----------------------Pins alias -----------------------------
Data_ready Alias Pinb.3
Chip_select Alias Portb.1
Reset_chip Alias Portb.2

'-----------------------Registers alias-------------------------
Dim Setup_reg As Byte
Dim Read_reg As Byte
Dim Comm_reg As Byte
Dim Data_read As String * 16
'--------------------Dimension---------------------------------
Dim Data_msb As Byte
Dim Data_lsb As Byte
Dim Complete_data As Word
'--------------------registers codes------------------------
Comm_reg = &B00010000
Setup_reg = &B01100110                                      'steup config : self calibration , 2.4Mhz , 25 sps ,normal mode
Read_reg = &B00111000                                       ' same as comm_reg : selecting data , read mode
'----------------------------------------------------------------

'------------------Spi Config -----------------------------------
Config Spi = Hard , Interrupt = Off , Data Order = Msb , Master = Yes , _
Polarity = Low , Phase = 0 , Clockrate = 128 , Noss = 0
'-----------------------------------------------------------------

'---------------------Sendig Configurations Data To Registers------------------
Ad7715:
                                                                                         'reset off
Spiinit
Chip_select = 0
Reset_chip = 0
Spiout Comm_reg , 1
Spiout Setup_reg , 1
Chip_select = 1
Reset_chip = 1

Do
Bitwait Data_ready , Reset
Chip_select = 0
Reset_chip = 0
Reset_chip = 1

Spiout Read_reg , 1
Waitms 40

Spiin Data_msb , 1
Spiin Data_lsb , 1
Waitms 30
Chip_select = 1

Complete_data = Makeint(data_lsb , Data_msb)
Data_read = Str(complete_data)
Calc = Complete_data * Res
Calc = Calc * Res_div

Print Calc ; "Volt"
Print Data_read
Print
Print
Lcd Calc ; "Volt"
Print "------------------------------------------"
Waitms 500

Loop

End